 ; Ŀ
 ;   Sch - text/attdef style change.                                       
 ;   Copyright 1992, 2001 by Rocket Software Ltd.                          
 ;   Welcome to the 20th Century.                                          
 ; 

 ; Ŀ
 ;   Subroutine Fibox - display a list of strings in a dialog box.         
 ;   Accepts one argument - the list.                                      
 ;   Returns a text string.                                                
 ; 
 (DEFUN FIBOX (styldt / fpath dcl_id num numf filnam fnam malist findx ret)
  (setq dcl_id (load_dialog "sch.dcl"))
  (new_dialog "sch" dcl_id)     ; must come before data for list box
 ; Ŀ
 ;   Make the Style list for the list box.                                 
 ; 
  (start_list "the_list")        ; read style data list into list box
  (setq num 0)
  (while (setq stylnm (nth num styldt))
         (add_list stylnm)
         (setq malist (cons stylnm malist))
         (setq num (1+ num)))
  (end_list)
  (setq malist (reverse malist))
  (set_tile "babtext" (strcat (itoa num) " text styles."))
 ; Ŀ
 ;   Actions for given buttons/selections.  Must come after New_dialog     
 ;   call and before Start_dialog.                                         
 ; 
  (action_tile "select_ok" "(setq findx (selok $reason))")
  (action_tile "the_list" "(setq findx (lisok $reason))")
  (action_tile "fcancel" "(setq findx ())")
 ; Ŀ
 ;   Run it.                                                               
 ; 
  (setq ret (start_dialog))
  (unload_dialog dcl_id)
 ; Ŀ
 ;   Return a style name or nil.                                           
 ; 
 (if (and findx (/= findx ""))
     (nth (read findx) malist) nil))
 ; Ŀ
 ;   Fibox end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lisok - if the list box generated a callback, see if it    
 ;   was a double click or an Enter, in which case return the value of     
 ;   the tile and close the dialog box.                                    
 ; 
 (DEFUN LISOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (= reason 4)
      (done_dialog)
      (set_tile "babtext" ""))
 lisval)
 ; Ŀ
 ;   Lisok end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Selok - if OK was pressed, see if a file name was          
 ;   selected, if so exit the dialog box and return the zero based index   
 ;   of that name.  Otherwise show an error.                               
 ; 
 (DEFUN SELOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (and lisval (/= lisval ""))
      (done_dialog)
      (set_tile "babtext" "You must select a style."))
 lisval)
 ; Ŀ
 ;   Selok end.                                                            
 ; 

 ; Ŀ
 ;   Sch.                                                                  
 ; 
 (DEFUN C:SCH ( / rew a stylst ss enam entt num asoc7 nustyl)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get a list of styles defined in the drawing.                          
 ; 
  (setq rew t)
  (while (setq a (cdr (assoc 2 (tblnext "style" rew))))
         (setq stylst (cons a stylst))
         (setq rew ()))
 ; Ŀ
 ;   Get an ss of all textlike entities.                                   
 ; 
  (prompt "Select text to change:")
  (if (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "mtext") (0 . "attdef")
                       (-4 . "or>"))))
 ; Ŀ
 ;   Call the dialog box to get a text style name from those defined       
 ;   in the drawing.                                                       
 ; 
      (setq nustyl (fibox stylst)))
 ; Ŀ
 ;   Process the text.                                                     
 ; 
  (setq num 0)
  (while (and ss nustyl (setq enam (ssname ss num)))
         (setq entt (entget enam))
         (setq num (1+ num))
         (setq asoc7 (assoc 7 entt))
         (entmod (subst (cons 7 nustyl) asoc7 entt)))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (cond ((= num 0) (prompt "\nNo changes."))
        ((= num 1) (prompt (strcat "\nOne line changed to " nustyl)))
        (t (prompt (strcat "\n" (itoa num) " Lines changed to " nustyl))))
 (princ))